import { world, system } from "@minecraft/server";
import { ActionFormData } from "@minecraft/server-ui";


world.afterEvents.playerInteractWithEntity.subscribe(event => {
    const { player, target } = event;
    if (!target || target.typeId !== "hivehub:game_sg") return;

    player.runCommandAsync("tp @s -1000 32 1000");
});


world.afterEvents.entityHitEntity.subscribe(event => {
    const { damagingEntity, hitEntity } = event;

    
    if (!(damagingEntity?.typeId === "minecraft:player")) return;

    
    if (!hitEntity || hitEntity.typeId !== "hivehub:game_sg") return;

    
    damagingEntity.runCommandAsync("tp @s -1000 32 1000").then(() => {
        system.runTimeout(() => {
            damagingEntity.runCommandAsync(`particle minecraft:knockback_roar_particle ~ ~ ~`);
            damagingEntity.addEffect("blindness", 20, {
  amplifier: 0,
  showParticles: false
});
            damagingEntity.playSound("mob.endermen.portal");
        }, 1); // delay by 1 tick (~50ms)
    });
});